#include <SDL.h>
#include <math.h>

#define WIDTH 24
#define HEIGHT img->h
#define AMPLITUDE 50
#define MAX_FPS 60

int main(int argc, char* argv[])
{
	Sint16 deformTable[WIDTH];
	const float radianConv = 3.1415927 / WIDTH;
	for (int i = 0; i < WIDTH; ++i) deformTable[i] = static_cast<Sint16>(AMPLITUDE * sin(i * radianConv));

	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER);

	SDL_WM_SetCaption("SDL Ripple Demo", "SDL Ripple Demo");

	SDL_Surface* img = SDL_LoadBMP("water.bmp");

	SDL_Surface* screen = SDL_SetVideoMode(img->w, img->h, img->format->BitsPerPixel, SDL_HWSURFACE | SDL_DOUBLEBUF);

	SDL_Rect deformSrc, deformDest;
	deformSrc.w = 1;
	deformSrc.h = HEIGHT;
	deformDest.y = 0;
	deformDest.w = 1;
	deformDest.h = HEIGHT;

	SDL_Event event;

	bool done = false;
	int position = 0;

	Uint32 baseTime, advTime;

	SDL_BlitSurface(img, NULL, screen, NULL);

	while (!done)
	{
		while (SDL_PollEvent(&event))
		{
			switch (event.type)
			{
				case SDL_QUIT:
					done = true;
					break;
				case SDL_KEYDOWN:
					if (event.key.keysym.sym == SDLK_ESCAPE) done = true;
					break;
			}
		}

		baseTime = SDL_GetTicks();

		if (position >= img->w) position = 0;
		else position++;

		deformSrc.x = position;
		deformDest.x = position;

		for (int i = 0; i < WIDTH; i++)
		{
			deformSrc.y = deformTable[i];

			SDL_BlitSurface(img, &deformSrc, screen, &deformDest);
			deformSrc.x++;
			deformDest.x++;
		}

		SDL_Flip(screen);

#if defined(MAX_FPS)
		advTime = SDL_GetTicks();
		if((advTime - baseTime) < (1000 / MAX_FPS)) SDL_Delay((1000 / MAX_FPS) - (advTime - baseTime));
#endif
	}

	SDL_FreeSurface(img);

	SDL_Quit();
	return 0;
}
