#include <stdio.h>

char* csfLanguageName[0xB] = 
{
	"US",
	"UK",
	"German",
	"French",
	"Spanish",
	"Italian",
	"Japanese",
	"Jabberwockie",
	"Korean",
	"Chinese",
	"Unknown"
};

const unsigned long ID_RA2MD_CSF = 0xBD835079;
const unsigned long ID_CSF_FILE = 0x43534620;

struct MIXFileEntry
{
	unsigned long	dwID;
	unsigned long	dwOffsetFromBodyStart;
	unsigned long	dwSizeInBytesOrSomethingLikeThat;
};

struct csfHeader
{
	unsigned long	dwCSFIdentifier;
	unsigned long	dwCSFVersion;
	unsigned long	dwNumLabels;
	unsigned long	dwNumLabels2;
	unsigned long	dwUnused;
	unsigned long	dwLanguage;
};


int GetYRLanguage(char* filename_LANGMD_MIX)
{

	short			wFiles;
	int				dwHeaderSize;
	FILE*			pLMix=NULL;
	MIXFileEntry	tmpFileInMix;
	csfHeader		tmpCSFHeader;
	int				nReturnValue;

	pLMix=fopen(filename_LANGMD_MIX,"r");
	if(pLMix!=NULL)
	{
		if(fseek(pLMix,0x4,SEEK_SET)==0)
		{
			fread(&wFiles,0x2,0x1,pLMix);

			dwHeaderSize=0xA+wFiles*0xC;

			if(fseek(pLMix,0x4,SEEK_CUR)==0)
			{
				
				for(register int i=0;i<(int)wFiles;i++)
				{
					fread(&tmpFileInMix,0xC,0x1,pLMix);


					if(tmpFileInMix.dwID==ID_RA2MD_CSF)
					{
						fseek(pLMix,tmpFileInMix.dwOffsetFromBodyStart+dwHeaderSize,SEEK_SET);
						fread(&tmpCSFHeader,0x18,0x1,pLMix);

						if(tmpCSFHeader.dwCSFIdentifier==ID_CSF_FILE)
						{
							nReturnValue=tmpCSFHeader.dwLanguage;
							if(nReturnValue>0xA)nReturnValue=0xA;

							return nReturnValue;
						}
						else
						{

							return 0xA;
						}
					}
					else
					{

					}
				}
			}
		}

		fclose(pLMix);
	}

	return 0xA;
}

int main()
{
	int tmpLanguage;
	char tmpNumberString[0x2];
	FILE* file_LANGUAGE_TMP;
	

	tmpLanguage=GetYRLanguage("langmd.mix");
	sprintf(tmpNumberString,"%d",tmpLanguage);

	file_LANGUAGE_TMP=fopen("language.tmp","wt");
	if(file_LANGUAGE_TMP!=NULL)
	{
		fputs(tmpNumberString,file_LANGUAGE_TMP);
	}
	fclose(file_LANGUAGE_TMP);


	return 0;
}